/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.tools;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.data.TexturePack;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;
import net.ftb.util.ErrorUtils;
import net.ftb.util.TrackerUtils;

public class TextureManager
extends JDialog {
    private static TexturePack updateTexture;
    private static ModPack updateModPack;
    private JPanel contentPane;
    private double downloadedPerc;
    private final JProgressBar progressBar;
    private final JLabel label;
    public static boolean updating;
    private static String sep;
    private static HashMap<String, String> installedTextures;

    public static String getTPDirectory(int MCVersion) {
        if (MCVersion < 160) {
            return "texturepacks";
        }
        return "resourcepacks";
    }

    public TextureManager(JFrame owner, Boolean model) {
        super((Frame)owner, (boolean)model);
        this.setResizable(false);
        this.setTitle("Downloading...");
        this.setDefaultCloseOperation(1);
        this.setBounds(100, 100, 313, 138);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(10, 63, 278, 22);
        this.contentPane.add(this.progressBar);
        JLabel lblDownloadingTexture = new JLabel("<html><body><center>Downloading texture pack...<br/>Please Wait</center></body></html>");
        lblDownloadingTexture.setHorizontalAlignment(0);
        lblDownloadingTexture.setBounds(0, 5, 313, 30);
        this.contentPane.add(lblDownloadingTexture);
        this.label = new JLabel("");
        this.label.setHorizontalAlignment(0);
        this.label.setBounds(0, 42, 313, 14);
        this.contentPane.add(this.label);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                TexturePackManagerWorker worker = new TexturePackManagerWorker(){

                    @Override
                    protected void done() {
                        TextureManager.this.setVisible(false);
                        super.done();
                    }
                };
                worker.execute();
            }
        });
    }

    public static void updateTextures() throws NoSuchAlgorithmException, IOException {
        boolean removed = false;
        ModPack pack = ModPack.getSelectedPack();
        int mcversion = Integer.parseInt(pack.getMcVersion().replace(".", ""));
        String installDir = Settings.getSettings().getInstallPath();
        File textureVersionFile = new File(installDir, pack.getDir() + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + "textureVersions");
        if (textureVersionFile.exists()) {
            TextureManager.populateInstalledTextures(pack);
            if (installedTextures.size() > 0) {
                for (TexturePack tp : TexturePack.getTexturePackArray()) {
                    if (!installedTextures.containsKey(tp.getName().toLowerCase()) || !tp.isCompatible(pack.getDir())) continue;
                    File texturePackFile = new File(installDir, pack.getDir() + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + tp.getUrl());
                    if (texturePackFile.exists()) {
                        String version = (Settings.getSettings().getPackVer().equalsIgnoreCase("Recommended Version") ? pack.getVersion() : Settings.getSettings().getPackVer()).replace(".", "_");
                        if (installedTextures.get(tp.getName().toLowerCase()).equalsIgnoreCase(version)) continue;
                        String packStr = mcversion > 160 ? "" : "/" + version;
                        if (!DownloadUtils.fileExists("texturepacks/" + tp.getName().replace(" ", "_") + "/" + pack.getDir() + "/" + packStr + "/" + tp.getUrl())) continue;
                        updating = true;
                        TextureManager man = new TextureManager(new JFrame(), (Boolean)true);
                        updateTexture = tp;
                        updateModPack = pack;
                        man.setVisible(true);
                        continue;
                    }
                    installedTextures.remove(tp.getName().toLowerCase());
                    removed = true;
                }
                if (removed) {
                    BufferedWriter out = new BufferedWriter(new FileWriter(textureVersionFile));
                    for (int i = 0; i < installedTextures.size(); ++i) {
                        out.write(installedTextures.keySet().toArray()[i] + ":" + installedTextures.values().toArray()[i]);
                        out.newLine();
                    }
                    out.flush();
                    out.close();
                }
            }
        }
    }

    private static void populateInstalledTextures(ModPack pack) {
        int mcversion = Integer.parseInt(pack.getMcVersion().replace(".", ""));
        File textureVersionFile = new File(Settings.getSettings().getInstallPath(), pack.getDir() + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + "textureVersions");
        if (installedTextures != null) {
            installedTextures.clear();
        } else {
            installedTextures = new HashMap();
        }
        if (textureVersionFile.exists()) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(textureVersionFile));
                while ((line = in.readLine()) != null) {
                    String[] split = line.toLowerCase().split(":");
                    if (split.length != 2) continue;
                    installedTextures.put(split[0], split[1]);
                }
                in.close();
            }
            catch (Exception e) {
                Logger.logError("Error populating installed textures.", e);
            }
        }
    }

    static {
        updating = false;
        sep = File.separator;
    }

    private class TexturePackManagerWorker
    extends SwingWorker<Boolean, Void> {
        private TexturePackManagerWorker() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            String installPath = Settings.getSettings().getInstallPath();
            TexturePack texturePack = TexturePack.getSelectedTexturePack();
            String compDir = texturePack.getSelectedCompatible();
            ModPack compPack = ModPack.getPack(compDir);
            int mcversion = Integer.parseInt(compPack.getMcVersion().replace(".", ""));
            if (updating) {
                texturePack = updateTexture;
                compDir = updateModPack.getDir();
                compPack = updateModPack;
            }
            if (compPack == null) {
                ErrorUtils.tossError("Error: Invalid Mod Pack destination selected.");
                return false;
            }
            String packVer = (Settings.getSettings().getPackVer(compDir).equalsIgnoreCase("Recommended Version") ? compPack.getVersion() : Settings.getSettings().getPackVer(compDir)).replace(".", "_");
            String packStr = mcversion > 160 ? "" : "/" + packVer;
            if (!compPack.hasCustomTP() && DownloadUtils.fileExists("texturepacks/" + texturePack.getName().replace(" ", "_") + "/" + "master_" + compPack.getMcVersion().replace(".", "_") + packStr + "/" + texturePack.getUrl())) {
                TextureManager.populateInstalledTextures(compPack);
                File oldFile = new File(installPath, texturePack.getSelectedCompatible() + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + texturePack.getUrl());
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                return this.downloadTexturePack(texturePack.getUrl(), texturePack.getName(), "master_" + compPack.getMcVersion().replace(".", "_"), compDir, packVer);
            }
            if (DownloadUtils.fileExists("texturepacks/" + texturePack.getName().replace(" ", "_") + "/" + compDir + packStr + "/" + texturePack.getUrl())) {
                TextureManager.populateInstalledTextures(compPack);
                File oldFile = new File(installPath, texturePack.getSelectedCompatible() + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + texturePack.getUrl());
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                return this.downloadTexturePack(texturePack.getUrl(), texturePack.getName(), compDir, compDir, packVer);
            }
            ErrorUtils.tossError("Error: Texture Pack not found for selected mod pack's version!");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean downloadUrl(String filename, String urlString) {
            BufferedInputStream in = null;
            OutputStream fout = null;
            try {
                int count;
                URL url_ = new URL(urlString);
                in = new BufferedInputStream(url_.openStream());
                fout = new FileOutputStream(filename);
                byte[] data = new byte[1024];
                int amount = 0;
                int steps = 0;
                int mapSize = url_.openConnection().getContentLength();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextureManager.this.progressBar.setMaximum(10000);
                    }
                });
                while ((count = in.read(data, 0, 1024)) != -1) {
                    ((FileOutputStream)fout).write(data, 0, count);
                    TextureManager.this.downloadedPerc = TextureManager.this.downloadedPerc + (double)count * 1.0 / (double)mapSize * 100.0;
                    amount += count;
                    if (++steps <= 100) continue;
                    steps = 0;
                    final String txt = amount / 1024 + "Kb / " + mapSize / 1024 + "Kb";
                    final int perc = (int)TextureManager.this.downloadedPerc * 100;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextureManager.this.progressBar.setValue(perc);
                            TextureManager.this.label.setText(txt);
                        }
                    });
                }
            }
            catch (MalformedURLException e) {
                Logger.logError("Texture Download Error", e);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                Logger.logError("Texture Download Error", e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    in.close();
                    fout.flush();
                    ((FileOutputStream)fout).close();
                }
                catch (IOException e) {
                    Logger.logWarn("Error while downloading texture pack", e);
                }
            }
            return true;
        }

        protected boolean downloadTexturePack(String texturePackName, String dir, String remoteName, String compDir, String packVer) throws IOException, NoSuchAlgorithmException {
            Logger.logInfo("Downloading Texture Pack");
            String installPath = Settings.getSettings().getInstallPath();
            ModPack pack = ModPack.getPack(compDir);
            int mcversion = Integer.parseInt(pack.getMcVersion().replace(".", ""));
            new File(installPath, compDir + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep).mkdirs();
            new File(installPath, compDir + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + texturePackName).createNewFile();
            String packStr = mcversion > 160 ? "" : "/" + packVer;
            if (this.downloadUrl(installPath + sep + compDir + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + texturePackName, DownloadUtils.getCreeperhostLink("texturepacks/" + dir.replace(" ", "_") + "/" + remoteName + packStr + "/" + texturePackName))) {
                File versionFile = new File(installPath, compDir + sep + "minecraft" + sep + TextureManager.getTPDirectory(mcversion) + sep + "textureVersions");
                installedTextures.put(dir.toLowerCase(), packVer);
                BufferedWriter out = new BufferedWriter(new FileWriter(versionFile));
                for (int i = 0; i < installedTextures.size(); ++i) {
                    out.write(installedTextures.keySet().toArray()[i] + ":" + installedTextures.values().toArray()[i]);
                    out.newLine();
                }
                out.flush();
                out.close();
                TrackerUtils.sendPageView(dir + " Install", dir + " / " + compDir + " / " + packVer);
                return true;
            }
            return false;
        }
    }
}

